import { Signer } from 'ethers'

export type ERC2771MetaTx = {
  from: string
  to: string
  value: number
  gas: number
  nonce: number
  deadline: number
  data: string
  signature: string
}

export const createMetaTx = async (
  metaTx: ERC2771MetaTx,
  forwarderAddr: string,
  forwarderChainId: number,
  signer: Signer,
): Promise<ERC2771MetaTx> => {
  let { from, to, value, gas, nonce, deadline, data } = metaTx

  metaTx.signature = await signer.signTypedData(
    {
      name: 'ERC2771CustomForwarder',
      version: '1',
      chainId: forwarderChainId,
      verifyingContract: forwarderAddr,
    },
    {
      ForwardRequest: [
        { name: 'from', type: 'address' },
        { name: 'to', type: 'address' },
        { name: 'value', type: 'uint256' },
        { name: 'gas', type: 'uint256' },
        { name: 'nonce', type: 'uint256' },
        { name: 'deadline', type: 'uint48' },
        { name: 'data', type: 'bytes' },
      ],
    },
    { from, to, value, gas, nonce, deadline, data },
  )
  return metaTx
}
